//	Common define for different K2s Libraries. <BR>
/**
* Device Error (not connected or failed).
*/
#define K2S_STATUS_ERROR		0x00000000

/**
* K2s is connected.
*/
#define K2S_SCAN_ACTIVE			0x00000001

/**
* Internal use only.
*/
#define K2S_SCAN_ENABLED		0x00000002

/**
* K2s photocell is detecting a document inserted.
*/
#define K2S_SCAN_READY			0x00000004

/**
* K2s is busy (someone else is acquiring).
*/
#define K2S_SCAN_BUSY			0x00000008

/**
* Front side acquisition is enabled.
*/
#define K2S_SCAN_FRONT			0x00000010

/**
* Rear side acquisition is enabled.
*/ 
#define K2S_SCAN_REAR			0x00000020


/**
* Internal use only.
*/
#define K2S_SINGLEPIPE			0x00000040


/**
* USB 2.0 high speed detected.
*/
#define K2S_HIGHSPEED			0x00000080

/**
* The connected K2s has a magnetic stripe reader.
*/
#define K2S_BDG_ACTIVE			0x00000100

/**
* The connected K2s has a magnetic stripe reader capable of reading Track1.
*/
#define K2S_BDG_T1ACTIVE		0x00000200

/**
* The connected K2s has a magnetic stripe reader capable of reading Track2.
*/
#define K2S_BDG_T2ACTIVE		0x00000400

/**
* The connected K2s has a magnetic stripe reader capable of reading Track3.
*/
#define K2S_BDG_T3ACTIVE 		0x00000800

/**
* Internal use only.
*/
#define K2S_BDG_ENABLED			0x00001000

/**
* New data on Track1.
*/
#define K2S_BDG_T1READY			0x00002000

/**
* New data on Track2.
*/
#define K2S_BDG_T2READY			0x00004000

/**
* New data on Track3.
*/
#define K2S_BDG_T3READY			0x00008000

/**
* Externa power supply is connected.
*/
#define K2S_SCAN_EXT_PWR		0x00010000 // externally powered, from Rev. 0x2100 (S.N. >= 216.000)

/**
* K2s document feeder photocell is detecting a document inserted.
*/
#define K2S_FEED_READY			0x00020000

/**
* rfu.
*/
#define K2S_READY_1			0x00040000
#define K2S_READY_2			0x00080000
#define K2S_READY_3			0x00100000
#define K2S_READY_4			0x00200000
#define K2S_READY_5			0x00400000
#define K2S_READY_6			0x00800000
#define K2S_READY_7			0x01000000
#define K2S_READY_8			0x02000000
#define K2S_READY_9			0x04000000
#define K2S_INKJET_READY		0x08000000
#define K2S_READY_1_DOUBLE		0x00800000
#define K2S_READY_2_DOUBLE		0x01000000
#define K2S_READY_3_DOUBLE		0x02000000
#define K2S_END_ACQ_FLAG		0x04000000