#ifndef _BMSERR_H_
#define _BMSERR_H_

/** 
* BancorMS result.
* @see BMSResultVal
*/
#define BMSResult int
#define BMS_FAILED( val ) ((BMSResult) (val) < 0)
#define BMS_WARNING( val ) ((BMSResult) (val) > 0)

/**	
* BMSResult values.
*/
enum BMSResultVal {

	/**	Success.															*/
	BMS__OK						=  0,
	
	/**	Warning - Unexpected image dimensions. 								*/
	BMS_WAR_IMAGE_DIMENSION		=  3,
	
	/**	Warning - The indicated zone it outside the document.				*/
	BMS_WAR_OCR_ZONE_OUTSIDE_DOC=  4,
	
	/**	Warning - Missing Calibration.<BR>
	* Recognition and image quality will be poor.							*/
	BMS_WAR_TOCALIBRATE			=  5,

	/**	Warning - Page is blank. See BMSIsPageBlank.						*/
	BMS_WAR_BLANK_PAGE			=  6,

	/**	Warning - OCR recognition truncated to available characters.		*/
	BMS_WAR_OCR_TRUNCATED		=  7,

	/**	Warning - Operation cancelled by the user.			 				*/
	BMS_WAR_CANCEL				=  8,

	/**	Warning - The device is missing external power.		 				*/
	BMS_WAR_NO_AUX_PWR			=  9,

	/**	Warning - The device sensors are dirty. Perform cleaning.			*/
	BMS_WAR_TOCLEAN				= 10,

	/**	Error -	IQA warning													*/
	BMS_WAR_IQA					= 11,

	/**	Error -	Generic error.												*/
	BMS_ERR						= -1,

	/**	Error - Device is busy. Close the previous istance of the device.	*/
	BMS_ERR_DEVICE_BUSY			= -2,

	/**	Error -	Invalid parameter.											*/
	BMS_ERR_INV_PARAMETER		= -3,

	/**	Error -	Out of memory.												*/
	BMS_ERR_OUT_OF_MEMORY		= -4,

	/**	Error -	Writing file.												*/
	BMS_ERR_FILE_WRITE			= -5,

	/**	Error -	Reading file.												*/
	BMS_ERR_FILE_READ			= -6,

	/**	Error -	Device version is incompatible with the Operating System.	*/
	BMS_ERR_SO					= -7,

	/**	Error -	Missing Initialization.										*/
	BMS_ERR_NO_INIT				= -8,

	/**	Error -	The device is missing external power.						*/
	BMS_ERR_NO_AUX_PWR			= -9,

	/**	Error -	Device timeout.												*/
	BMS_ERR_TIMEOUT				= -10,

	/**	Error -	SW version does not supported the required operation/value.	*/
	BMS_ERR_NOT_SUPPORTED_SW	= -11,

	/**	Error -	Device not found.														*/
	BMS_ERR_DEVICE_NOT_FOUND	= -14,

	/**	Error -	HW version does not support the required operation/value.				*/
	BMS_ERR_NOT_SUPPORTED_HW	= -15,

	/**	Error -	Function called while dll is detaching.									*/
	BMS_ERR_DLL_DETACHING	    = -17,

	/**	Error -	The device is not ready (not connected, riconnecting or not working).	*/
	BMS_ERR_NOT_READY			= -18,

	/**	Error -	Operation aborted by the user.											*/
	BMS_ERR_USER_CANCEL			= -19,

	/**	Error -	Unexpected image dimensions.											*/
	BMS_ERR_IMAGE_DIMENSION		= -20,

	/**	Error -	Device failure.															*/
	BMS_ERR_DEVICE_FAILURE		= -21,

	/**	Error -	Calibration error.														*/
	BMS_ERR_CALIBRATION			= -22,

	/**	Error -	Calibration error - sheet too short.									*/
	BMS_ERR_CALIB_TOO_SHORT		= -23,

	/**	Error -	OCR general error.														*/
	BMS_ERR_OCR					= -30,

	/**	Error -	OCR Area too small.														*/
	BMS_ERR_OCR_AREA_TOO_SMALL	= -31,

	/**	Error -	OCR Font not enabled.													*/
	BMS_ERR_OCR_FONT_NOT_ENABLED= -33,

	/**	Error -	Error opening OCR database.												*/
	BMS_ERR_OCR_DB_OPEN			= -34,

	/**	Error -	Magnetic stripe reading error.											*/
	BMS_ERR_BDG_FAILURE			= -70,

	/**	Error -	Magnetic stripe - missing start sentinel.								*/
	BMS_ERR_BDG_MISSING_START	= -71,

	/**	Error -	Magnetic stripe - missing end sentinel.									*/
	BMS_ERR_BDG_MISSING_END		= -72,

	/**	Error -	Magnetic stripe - parity error.											*/
	BMS_ERR_BDG_NOPARITY		= -73,

	/**	Error -	Magnetic stripe - LCR error.											*/
	BMS_ERR_BDG_LCR				= -74,

	/**	Error -	Magnetic stripe - too many chars read.									*/
	BMS_ERR_BDG_TOO_MANY_CHAR	= -75,

	/**	Error -	Inkjet - generic error.													*/
	BMS_ERR_INKJET				= -80,

	/**	Error -	Inkjet - incomplete printing											*/
	BMS_ERR_INKJET_INCOMPLETE	= -81,
    
	/**	Error -	IQA error																*/
	BMS_ERR_IQA					= -90,

	/**	Error -	invalid license key														*/
	BMS_ERR_INVALID_KEY			= -100,
    
	/**	Error -	license file is missing													*/
	BMS_ERR_MISSING_LICENSE		= -101,

	/**	rfu																				*/
	BMS_ERR_DOUBLE_FEED			= -111,
	
	/**	rfu																				*/
	BMS_ERR_INVALID_SEQUENCE	= -112,
    
	/**	rfu																				*/
	BMS_ERR_EDGE_DETECTED		= -113,            

	/**	rfu																				*/
	BMS_ERR_INVALID_SEQUENCE_2	= -114,


};

#endif
