/****************************************************
	General
 ****************************************************/
#ifndef _K2SGENERAL_H_
#define _K2SGENERAL_H_

#define N_SIDE						2
#define N_SIDE_WITH_BACKLIGHT		3

#define REAR						0
#define FRONT						1

#define BACKLIGHT					2

#define REAR_AUTO					8
#define FRONT_AUTO					9

/**
* Automatic JPG quality managment to match IQA file dimensions requirements for Italian Check
* @see BMSImgSave
* @see BMSImgSave2
* @see BMSImgSave3
* @see BMSImgSave4
*/ 
#define QUALITY_ITA_CHECK			999


/**
* Handle returned by initialization function. To be relase with BMSClose.
* @see BMSClose
* @see BMSInitializeSN
*/
typedef void* BMSHandle;

#define INVALID_HANDLE_VALUE ((void*) 0xFFFFFFFF)
#define MAX_PATH 260

/**
* Handle returned by initialization function. To be relase with BMSClose.
* @see BMSClose
* @see BMSInitializeSN 
* @see BMSInitializeNum
*/
typedef void* HANDLE;

/**
* Supported image formats.
*/
enum K2S_IMG_FORMAT {
	/** JPEG format.															*/
	JPEG			= 0x00,
	/** Tiff fax3 - black&white - 1 bit per pixel (no EOL).						*/
	TIF_CCITTFAX3	= 0x01,
	/** Tiff fax4 - black&white - 1 bit per pixel.								*/
	TIF_CCITTFAX4	= 0x02,
	/** Lempel-Ziv-Welch (LZW) lossless compression - 1, 8 or 24 bit per pixel.	*/
	TIF_LZW			= 0x03,
	/** Microsoft Bitmap - 1, 8 or 24 bit per pixel.							*/
	BMP				= 0x04,
	/** Tiff uncompressed = 1, 8 or 24 bit per pixel, not compressed.			*/
	TIF				= 0x05,
	/** Tiff with JPEG compression.												*/
	TIF_JPEG		= 0x06,
	/** PDF document with JPEG images. 8 bit is only grayscale.					*/
	PDF_JPEG		= 0x07,
	/** PNG - Portable Network Graphics	- added in  2.1.7.2;					*/
	PNG				= 0x08,
	/** PDF document with TIFF images.											*/
	PDF_TIFF		= 0x09,
};

/**
* Rotation values.<BR>
* For output images and OCR doc (separatelly).
*/
enum K2S_ROTATION {
	/** No rotation.														*/
	ROT_0			= 0x0000,
	/** Document is rotated 90 degree clockwise (respect template).			*/
	ROT_RIGHT		= 0x0100,
	/** Document is rotated 180 degree (respect template).					*/
	ROT_180			= 0x0200,
	/** Document is rotated 90 degree anticlockwise (respect template).		*/
	ROT_LEFT		= 0x0300,
	/** equals to ROT_0 if no OCR is performed. Detected document rotation, 
	    in case of specialy type of documents.								*/
	ROT_AUTO		= 0x0400,
};

/**
* Return valus for K2S_PAR_PASSTHRU_CHECK. See K2S_PAR_PASSTHRU_CHECK.
*/
enum K2S_PASSTHRU_VAL {
	/** no scanning command received									*/
	NO_DOC					= 0x0000,
	/** the scanned document passed throught. 
	The check is based on the rear image analisys (background on the 
	last part of the scanned image).									*/
	PASSTHRU_DOC			= 0x0001,
	/** document removed from the feeder side 
	(a dark document can fit in this case)								*/
	DARK_OR_NO_PASSTHRU_DOC	= 0x0002,
	/** not detactable													*/
	NOT_DECTABLE			= 0x0004,
};

/** ParId values for BMSSetParameter/BMSGetParameter.	*/
enum K2S_PAR_ID {
	/** Set color or gray acquisition.<BR>
	* See K2S_COLOR. Default is K2S_C_GRAY.				*/
	K2S_PAR_PIXELTYPE	= 0,

	/**	Enable/disable automatic image rotation.<BR>
	* See K2S_PAR_ON_OFF. Default is K2S_PAR_ON.		*/
	K2S_PAR_AUTOROTATE	= 1,

	/** Enable/disable automatic image cut.<BR> 
	* ParVal <= 0 means off.<BR> 
	* ParVal = 1 (default) means with external border removal.<BR>
	* ParVal>1 means with internal border removal. 
	* Default is 1.										*/
	K2S_PAR_AUTOTRIM	= 2,

	/** Used for Customer Special Build.				*/
	K2S_PAR_DOC_TYPE	= 3,

	/** Enable/disable image enhancement.<BR>
	* See K2S_PAR_ON_OFF. Default is K2S_PAR_ON.		*/
	K2S_PAR_ENHANCE_IMG	= 4,

	/** Set b&w threshold value for Front image.<BR>
	*	ParVal between 0 and 255.						*/
	K2S_PAR_BW_THR_F	= 5,

	/** Set b&w threshold value for Rear image.<BR>
	*	ParVal between 0 and 255.						*/
	K2S_PAR_BW_THR_R	= 6,

	/** To set max document height at 150 dpi. ParVal = 0 means standard buffer (suitable for A4).*/
	K2S_PAR_MAX_HEIGHT_150DPI = 9,

	/** Reserved for future use.						*/
	K2S_PAR_IMG_BUF		= 10, 

	/** Reserved for future use.						*/
	K2S_PAR_IMG_BUF_FRMT= 11,

	/** Reserved for future use.						*/
	K2S_PAR_IMG_BUF_DPI	= 12,

	/** Reserved for future use.						*/
	K2S_PAR_IMG_BUF_MODE  = 13,

	/** After an image acquisition, it returns a K2S_PASSTHRU_VAL. Only get.*/
	K2S_PAR_PASSTHRU_CHECK= 14,

	/** True for remote version. Only get.*/
	K2S_PAR_REMOTE		  = 15,

	/** To enable/disable different barcode types when using BARCODE OCR font. Only Set. See K2S_BARCODE*/
	K2S_PAR_BARCODE_TYPE  = 16,

	/** To change special characters mapping. See K2S_VAL_E13B_MAPPING.*/
	K2S_PAR_E13B_MAPPING = 17,

	/** To enable document backlight. Required for microperforation check.	*/
	K2S_PAR_BACKLIGHT_ENABLE = 19,

	/** If set, CMC7 and E13B are read as MICR_CMC7, MICR_E13B.			*/
	K2S_PAR_ONLY_MICR = 20,

	/** rfu			*/
	K2S_PAR_IQA_ENABLE = 21,

	/** Set photocell timeout (in msec).<BR>
	* ParVal >= 0, in ms; = 0 means ignore photocell.
	* Default is 10000 ms = 10 s.						*/
	K2S_PAR_TIMEOUT_PHOTOCELL	= 100,


	/** Set magnetic stripe reader timeout (in msec).<BR>
	* ParVal >= 0, in ms; 0 to return immediatelly.
	* Default is 10000 ms = 10 s.						*/
	K2S_PAR_TIMEOUT_MAGSTRIPE	= 101,	
	
	/** Set how long (in msec) the device will wait before start acquisition after detecting doc presence. It can be usefull in single feed acquisition to stabilize document.<BR>
	* ParVal >= 0, in ms; 0 to start immediatelly.
	* Default is 0 ms = 0 s.						*/
	K2S_PAR_MSEC_WAIT_START	= 102,

};

/** ParVal for K2S_PAR_BARCODE_TYPE		*/
enum K2S_BARCODE {

	/**	All disabled.					*/
	K2S_BARCODE_NONE = -2,
	/**	All enabled.					*/
	K2S_BARCODE_ALL  = -1,

	K2S_BARCODE_3OF9 = 0,
	K2S_2OF5INTERLEAVED = 1,
//	K2S_2OF5NONINTERLEAVED = 2,	rfu
	K2S_CODE93 = 3,
	/* Code 128. FNC1, FNC2, FNC3, FNC4 and SHIFT ignored.		*/
	K2S_CODE128 = 4,
//	K2S_UCC128 = 5, rfu
	K2S_CODABAR = 6,
	K2S_UPCA = 7,
	K2S_UPCE = 8,
	K2S_EAN8 = 9,
	K2S_EAN13 = 10,
//	K2S_POSTNET = 11,	rfu
//	K2S_PDF417 = 12,	use PDF417 font instead of BARCODE
//	K2S_2OF5INDUSTRIAL = 13,	rfu
//	K2S_2OF5MATRIX = 14,	rfu
//	K2S_2OF5DATALOGIC = 15,	rfu
//	K2S_2OF5IATA = 16,	rfu
//	K2S_3OF9FULLASCII = 17,	rfu
//	K2S_CODABARWITHSTARTSTOP = 18,	rfu
//	K2S_MAXICODE = 19,	rfu
};

/** ParVal for K2S_PAR_PIXELTYPE		*/
enum K2S_COLOR {

	/**	Grayscale.						*/
	K2S_C_GRAY	= 1,

	/**	Color (RGB).					*/
	K2S_C_RGB	= 2,

	/**	Red.							*/
	K2S_C_RED	= 3,

	/**	Green - reserved for future use	*/
	K2S_C_GRN	= 4,

	/**	Blu   - reserved for future use	*/
	K2S_C_BLU	= 5,

	/**	Infrared - special HW is required */
	K2S_C_IR	= 8,

	/**	Ultraviolet - special HW is required */
	K2S_C_UV	= 16,

};

/** ParVal for different K2S_PAR_ID		*/
enum K2S_PAR_ON_OFF {
	/** Enable			*/
	K2S_PAR_ON	= 1,
	/** Disable			*/
	K2S_PAR_OFF	= 0,
};

/** ParVal for different K2S_PAR_E13B_MAPPING */
enum K2S_VAL_E13B_MAPPING {
	/** Transit = ':'   
	*	Amount  = '='	
	*	On-Us	= '<'
	*	Dash	= ';'	*/
	K2S_E13B_MAPPING_0 = 0,

	/** Transit = ':'   
	*	Amount  = ';'	
	*	On-Us	= '<'
	*	Dash	= '='	*/
	K2S_E13B_MAPPING_1 = 1,

	/** Transit = 'A'   
	*	Amount  = 'B'	
	*	On-Us	= 'C'
	*	Dash	= 'D'	*/
	K2S_E13B_MAPPING_2 = 2,

	/** Transit = '-'   
	*	Amount  = '#'	
	*	On-Us	= '$'
	*	Dash	= '%'	*/
	K2S_E13B_MAPPING_3 = 3,
};
/**	
* Region of interest (Roi)<BR>
* in dpi, at resolution (dpi) required for this side
*/
typedef struct {
	long	left;
	long	top;
	long	width;
	long	height;
} BMSRoi;

/** 
* max OCR zones 
*/
#define MAX_OCR_ZONE  20

/** 
* Valid values for OCR font/set of fonts.
*/
enum K2S_OCR_FONT {
	/**	Ignore this zone - do not decode								*/
	NO_DECODE = -1,

	/** CMC7 font.<BR> This magnetic font is recognised optically).<BR>
	* Set is '0'-'9', ':', '=', '>', '<', ';'.
	*/
	CMC7      =  0,

	/** E13B font.<BR> This magnetic font is recognised optically).<BR>
	* Set is '0'-'9', ':', '=', '<', ';'.
	*/
	E13B      =  1,

	/**	
	* OCR-A Eurobanking subset 2.
	*/
	OCRA1_EB2 =  2,

	/**	
	* OCR-B. 
	* see <a href=_ocrb.gif>font image</a>.
	*/
	OCRB1	  =  3,

	/**	
	* OCR-B Eurobanking subset 1
	* see <a href=_ocrb_eb1.gif>font image</a>.
	* see also OCRB1_BOL (for Italian "Bollettino").
	*/
	OCRB1_EB1 =  4,

	/**	
	* OCR-B Eurobanking subset 2
	* see <a href=_ocrb_eb1.gif>font image</a>.
	*/
	OCRB1_EB2 =  5,

	/** CMC0 font.<BR> This magnetic font is recognised optically).<BR>
	* Set is '0'-'9', ':', '=', '>', '<', ';'							
	* see <a href=_cmc.gif>font image</a>.
	*/
	CMC0	  =  6,

	/**	
	* Barcodes.<BR>
	* See K2S_BARCODE for different types.
	*/
	BARCODE   =  7,

	/** 
	* PDF417 bidimensional barcode
	*/
	PDF417    =  8,

	/** For custromer specific requirements.							*/
	USER1	  =  9,

	/** For custromer specific requirements.							*/
	USER2	  =  10,

	/** For custromer specific requirements.							*/
	USER3	  =  11,

	/** For custromer specific requirements.							*/
	USER4	  =  12,

	/** For custromer specific requirements.							*/
	USER5	  =  13,

	/** For custromer specific requirements.							*/
	USER6	  =  14,

	/** For custromer specific requirements.							*/
	USER7	  =  15,

	/** For custromer specific requirements.							*/
	USER8	  =  16,

	/** For custromer specific requirements.							*/
	USER9	  =  17,

	/** For custromer specific requirements.							*/

	USER10	  =  18,
	/** For custromer specific requirements.							*/
	USER11	  =  19,

	/** For custromer specific requirements.							*/
	USER12	  =  20,

	/** For custromer specific requirements.							*/
	USER13	  =  21,

	/** For custromer specific requirements.							*/
	USER14	  =  22,

	/** For custromer specific requirements.							*/
	USER15	  =  23,

	/** For custromer specific requirements.							*/
	USER16	  =  24,

	/** CMC7 font, read magnetically.<BR> The magnetic head option has to be mounted.<BR>
	* Set is '0'-'9', ':', '=', '>', '<', ';'.
	*/
	MICR_CMC7 =  32,

	/** E13B font, read magnetically.<BR>  The magnetic head option has to be mounted.<BR>
	* Set is '0'-'9', ':', '=', '<', ';'.
	*/
	MICR_E13B =  33,

	/** Automatic detection between CMC7 and E13B - rfu
	*/
	MICR_AUTO =  34,

	/** Italian check Microperforation - check number
	*/
	MICROPERFORATION =  35,

	/** Datamatrix - rfu
	*/
	DATAMATRIX =  36,

	/** QR-Code - rfu
	*/
	QRCODE =  37,

	/**	
	* OCR-B Eurobanking subset '0'-'9', '+', '<', '>'
	* Added in 2.1.6.3.
	*/
	OCRB1_BOL =  38,

	/**	
	* OCR-B Eurobanking subset '0'-'9', '-'
	* Added in 2.1.7.2.
	*/
	OCRB1_ITA_CHECK = 39,

	/** Italian check Microperforation - beneficiary field
	*/
	MICROPERFORATION_BENEFICIARY =  40,

	/** Italian check Microperforation - ammount field
	*/
	MICROPERFORATION_AMOUNT =  41,

	/** 
	* Combination of CMC7 and OCRB1_EB1.<BR>
	* The engine tries to decode with CMC7; 
	* if no codeline (len<3) is detected, it tries with OCRB (Eurobanking I set).
	*/
	CMC7_OR_OCRB1_EB1		= 100,

	CMC7_OR_OCRB1_EB1_PLUS	= 101, // it tries to decode with CMC7on the front side - lower bottom part, 
								   // then rear side - lower bottom part;
								   // if no codeline (len<3) is detected, it tries with OCRB (Eurobanking I set);
								   // NOTE: zone side and dimensions are ignored

	CMC7_PLUS				= 110, // it tries to decode CMC7 on the front side - lower bottom part, 
								   // then front side - higher bottom par, then rear side - lower bottom part, 
								   // finally rear side - higher bottom part;
								   // only space flag is considered; other OCR zone parameters are ignored.
								   // NOTE: zone side and dimensions are ignored

	CMC7_ROT180				= 111, // upsidedown
	
	BARCODE_OR_PDF417		= 120,

   	BARCODE_VERTICAL		= 121,

	/** Specific barcode - the first barcode of the correspondign type is returned.		*/
	BARCODE_3OF9			= 300,

	/** Specific barcode - the first barcode of the correspondign type is returned.		*/
	BARCODE_2OF5INTERLEAVED	= 301,

	/** Specific barcode - the first barcode of the correspondign type is returned.		*/
	BARCODE_CODE93			= 303,
	/** Specific barcode - the first barcode of the correspondign type is returned.
		Code 128. FNC1, FNC2, FNC3, FNC4 and SHIFT ignored.								*/
	BARCODE_CODE128			= 304,

	/** Specific barcode - the first barcode of the correspondign type is returned.		*/
	BARCODE_CODABAR			= 306,

	/** Specific barcode - the first barcode of the correspondign type is returned.		*/
	BARCODE_UPCA			= 307,

	/** Specific barcode - the first barcode of the correspondign type is returned.		*/
	BARCODE_UPCE			= 308,

	/** Specific barcode - the first barcode of the correspondign type is returned.		*/
	BARCODE_EAN8			= 309,

	/** Specific barcode - the first barcode of the correspondign type is returned.		*/
	BARCODE_EAN13			= 310,
};

/**
* OCR zone structure.<BR>
* It contains details related to the i-th OCR zone.
* For each zone you can define separatelly dimensions, font and enable/disable spacing.
* Dimensions are given in dpi, at a fixed resolution of <b>150 dpi</b>!<BR>
* See <a href=_zone.gif>zone image</a>.<BR>
* @param <b>left</b>		long -	OCR zone left corner at 150 dpi.<BR>
*									If >=0, from left border (see in blue in <a href=_zone.gif>zone image</a>).
*									From right border if <0 (in green in zone image).
* @param <b>top</b>			long - 	OCR zone top corner at 150 dpi.<BR> 
*									If >=0, from top border (see in blue in <a href=_zone.gif>zone image</a>).
*									From bottom border if <0 (in green in zone image).
* @param <b>width</b>		long - 	OCR zone width at 150 dpi (in yellow in <a href=_zone.gif>zone image</a>).
*									It must be >=0. If 0, whole width is used (ignoring left).
* @param <b>height</b>		long - 	OCR zone height at 150 dpi (in yellow in <a href=_zone.gif>zone image</a>).
*									It must be >=0. If 0, whole height is used (ignoring left).
* @param <b>side</b>		short -	FRONT or REAR.
* @param <b>OCRchar</b>		short -	OCRChar value.
* @param <b>space</b>		short -	1 to enable space, 0 to disable space.
* @param <b>nCharRead</b>	short -	n. of Char returned after reading
* @see BMSOCRDoc
*/
typedef struct {
	long	left;
	long	top;
	long	width;
	long	height;
	short	side;
	short	OCRchar;
	short	space;
	short	nCharRead;
} BMSOCRZone;

/**
* OCR template structure.<BR>
* It contains details related to the OCR zones.
* Up to MAX_OCR_ZONE zones can be defined, allowing high flexibility.
* @param <b>nZn</b>			long -	Between 0 and MAX_OCR_ZONE.
* @param <b>rotation</b>	short -	ROT_0, ROT_RIGHT, ROT_180 or ROT_LEFT (see Rotation).
* @param <b>Zn</b>			BMSOCRZone[MAX_OCR_ZONE] - Array of BMSOCRZone.
* @see BMSOCRZone
*/
typedef struct {
	// Obsolete. 0 for new development.
	short	width;
	// Obsolete. 0 for new development.
	short	height;
	short   nZn;
	short	rotation;
	BMSOCRZone Zn[MAX_OCR_ZONE];
} BMSOCRDoc;

#endif // _K2SGENERAL_H_