/**
*	Composition flags
*/

/**	
* No Device detected.
*/
#define DEVICE_NONE			0x0000
/**	
* Front CIS detected.
*/
#define DEVICE_SCAN1		0x0001
/**	
* Rear  CIS detected.
*/
#define DEVICE_SCAN2		0x0002
/**	
* Not implemented.
*/
#define DEVICE_SMARTCARD1	0x0004
/**	
* Not implemented.
*/
#define DEVICE_SMARTCARD2	0x0008
/**	
* Magnetic stripe reader with Track1 detected.
*/
#define DEVICE_BADGE1		0x0010 // track 1

/**	
* Magnetic stripe reader with Track2 detected.
*/
#define DEVICE_BADGE2		0x0020 // track 2

/**	
* Magnetic stripe reader with Track3 detected.
*/
#define DEVICE_BADGE3		0x0040 // track 3

/**	
* internal use
*/
#define DEVICE_FOTO1		0x0080
#define DEVICE_FOTOCELL		DEVICE_FOTO1 // obsolete

/**	
* Document feeder detected.
*/
#define DEVICE_DOCFEEDER	0x0100

/**	
* Inkjet1 option detected.
*/
#define DEVICE_INKJET1		0x0200

/**	
* rfu
*/
#define DEVICE_INKJET2		0x0400

/*
* internal use
*/
#define DEVICE_FOTO2		0x0800

/*
* rfu
*/
#define DEVICE_MICR			0x1000

/*
* internal use
*/
#define DEVICE_FOTO3		0x2000

/*
* internal use
*/
#define DEVICE_EXT_PWR_CHECK	0x4000


/**	
* Thermal printer detected.
*/
#define DEVICE_THR_PRT			0x0080

/**	
* Double Feed fotocell detected (from fw 0x4005) - rfu
*/
#define DEVICE_DOUBLE_FOTO		0x010000

/**	
* Backlight detected.
*/
#define DEVICE_BACKLIGHTED		0x020000

/**	
* internal use
*/
#define DEVICE_FOTOINT			0x00040000

/**
* internal use
*/
#define DEVICE_SLOW			0x00080000

/**
* internal use
*/
#define DEVICE_600DPI_RGB       0x00100000

#define DEVICE_WITH_CALIB_DATA  0x00400000

#define DEVICE_FOTO5            0x02000000
#define DEVICE_WITH_UV			0x01000000 // version 0x2248 (07/03/2018) from fw 0x5010

#define DEVICE_RFID             0x04000000

#define DEVICE_FOTO_TUNING		0x08000000 //from fw 0x5003
//#define DEVICE_FOTO_OUT_MID	0x10000000 //from fw 0x5003 - solo BSC
#define DEVICE_THICK_DOC		0x20000000 // from fw 0x5003
#define DEVICE_LINE_ALLIGNER	0x40000000 // 02/02/2017
#define DEVICE_WITH_IR			0x80000000  // version 0x2248 (07/03/2018) from fw 0x5010

//#define DEVICE_FAN_OUT		0x00000001 // from fw 0x5007 - compositionHigh
#define DEVICE_FINGER_PRINT		0x00000002 // from fw 0x5010 - compositionHigh
//#define DEVICE_FOTO_2M		0x00000004 // from fw 0x5011 - compositionHigh
//#define DEVICE_FOTO_2M_D		0x00000008 // from fw 0x5011 - compositionHigh
#define DEVICE_END_ACQ			0x00000010 // from fw 0x5011 - compositionHigh
#define DEVICE_BUZZER			0x00000020 // from fw 0x5011 - compositionHigh
