/* 
 * File:   Main.cpp
 * Author: bancor srl, SW team
 */

/******************************************************************************
  bancor srl1
 * 

  This demo program explains the action to be performed on the K2s to perform
  the capture of an image and of the related codeline.

  Integrated reading is presented.

  Steps are:
  . Initialization
  . Integrated reading
  . Closure of the device
  
  As the device needs to be calibrated once, there is another voice in the menu,
  corresponding to Calibration.

  Refer to K2sLib.h for prototypes, structures, parameter description

 ******************************************************************************/

#include <errno.h>
#include <sys/stat.h> 
#include <list>
#include <cstdlib>
#include <stdio.h>

#include <unistd.h>
#include <time.h>
#include <string>
#include <sstream>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <math.h>
#include <sys/time.h>

#include "K2sGeneral.h"
#include "K2sComp.h"
#include "K2sResult.h"
#include "K2sStatus.h"
#include "K2sLib.h"

unsigned long _linuxclock( void )
{
    struct timeval tv;
    struct timezone tz;
    unsigned long retval;

    memset(&tv,0,sizeof(struct timeval));
    memset(&tz,0,sizeof(struct timezone));

    gettimeofday(&tv,&tz);
    retval = tv.tv_sec * 1000 + tv.tv_usec / 1000; // msec
    return (retval);
}
 
using namespace std;

void printTicketResult(BMSOCRDoc doc, char *cdl);
void printError(void);
int isNumber(const char str[]);

void ReadCheck(BMSHandle hDevice)
{
    BMSResult res;
    unsigned long status;
    unsigned long tick;
    short dpi = 300;

    printf("\n ....Insert Your Document Please....\n");

    tick = _linuxclock();
    while( 1 )
    {
        status = BMSReadStatusL( hDevice );
        if (status==K2S_STATUS_ERROR) {
            printf( "Device error\n" );
            return;
        }

        if(( status & K2S_SCAN_READY ) == K2S_SCAN_READY)
            break;
        if (( status & K2S_FEED_READY) == K2S_FEED_READY)
            break;
        if( status & K2S_STATUS_ERROR ) {
            printf( "Error checking feeder\n" );
            continue;
        }

        if( ( _linuxclock() - (unsigned long)tick ) > (unsigned long)30000 ) // msec
        {
                printf( "\nTimeout doc in feeder\n" );
                return;
        }

        usleep( 100000 ); // 100.000 micro_secondi, 100 mSec
        printf(".");

    }
    printf("\n");
    
    BMSSetParameter(K2S_PAR_PIXELTYPE, K2S_C_GRAY);
    //BMSSetParameter(K2S_PAR_PIXELTYPE, K2S_C_RGB);
    BMSSetParameter(K2S_PAR_AUTOTRIM, K2S_PAR_ON);
    BMSSetParameter(K2S_PAR_AUTOROTATE, K2S_PAR_ON);

     
    BMSOCRDoc OcrDoc = {0};
    
    OcrDoc.Zn[OcrDoc.nZn].OCRchar = MICR_CMC7; // font
    //OcrDoc.Zn[OcrDoc.nZn].OCRchar =  CMC7; // font    
    OcrDoc.Zn[OcrDoc.nZn].space		=     1;
    OcrDoc.Zn[OcrDoc.nZn].side	= FRONT;
    OcrDoc.Zn[OcrDoc.nZn].left	=     0; 	OcrDoc.Zn[OcrDoc.nZn].width	=     0;
    OcrDoc.Zn[OcrDoc.nZn].top	=  -100;	OcrDoc.Zn[OcrDoc.nZn].height	=   100;
    OcrDoc.nZn++;

    char fnameRes[MAX_PATH] = {0};

    BMSImgCreate1(hDevice, dpi, dpi, 0);

    // image acquisition and codeline returning
    char codeline[512] = {0};
    char confidence[512] = {0};

    res = BMSImgScan1 (hDevice, &OcrDoc, codeline, confidence, sizeof(codeline));
    printf("MICR %s\n", codeline);

    // image save - FRONT_AUTO  as in MICR reading the FW knows which is the front side
    char fnameImg[] = "Check_F.jpg";
    BMSImgSave(hDevice, FRONT_AUTO, NULL, QUALITY_ITA_CHECK, JPEG | ROT_AUTO, fnameImg);
    char *c = strstr(fnameImg, "F.jpg");
    *c = 'R';
    BMSImgSave(hDevice, REAR_AUTO, NULL, QUALITY_ITA_CHECK, JPEG | ROT_AUTO, fnameImg);
    BMSImgFree(hDevice);
}

void ReadBarcode(BMSHandle hDevice)
{
    BMSResult res;
    unsigned long status;
    unsigned long tick;
    short dpi = 300;

    printf("\n ....Insert Your Document Please....\n");

    tick = _linuxclock();
    while( 1 )
    {
        status = BMSReadStatusL( hDevice );
        if (status==K2S_STATUS_ERROR) {
            printf( "Device error\n" );
            return;
        }

        if(( status & K2S_SCAN_READY ) == K2S_SCAN_READY)
            break;
        if (( status & K2S_FEED_READY) == K2S_FEED_READY)
            break;
        if( status & K2S_STATUS_ERROR ) {
            printf( "Error checking feeder\n" );
            continue;
        }

        if( ( _linuxclock() - (unsigned long)tick ) > (unsigned long)30000 ) // msec
        {
                printf( "\nTimeout doc in feeder\n" );
                return;
        }

        usleep( 100000 ); // 100.000 micro_secondi, 100 mSec
        printf(".");

    }
    printf("\n");
    
    BMSSetParameter(K2S_PAR_PIXELTYPE, K2S_C_GRAY);
    //BMSSetParameter(K2S_PAR_PIXELTYPE, K2S_C_RGB);
    BMSSetParameter(K2S_PAR_AUTOTRIM, K2S_PAR_ON);
    BMSSetParameter(K2S_PAR_AUTOROTATE, K2S_PAR_ON);

    //BMSSetParameter(K2S_PAR_DOC_TYPE, 1);
    
    BMSOCRDoc OcrDoc = {0};
    
    OcrDoc.Zn[OcrDoc.nZn].OCRchar =  BARCODE; // font    
    OcrDoc.Zn[OcrDoc.nZn].space	=     1;
    OcrDoc.Zn[OcrDoc.nZn].side	= FRONT;
    OcrDoc.Zn[OcrDoc.nZn].left	=     0; 	OcrDoc.Zn[OcrDoc.nZn].width	=     0;
    OcrDoc.Zn[OcrDoc.nZn].top	=     0;	OcrDoc.Zn[OcrDoc.nZn].height	=     0;
    OcrDoc.nZn++;

    BMSImgCreate1(hDevice, dpi, dpi, 0);

    // image acquisition and codeline returning
    char codeline[512] = {0};
    char confidence[512] = {0};
    
    res = BMSImgScan1 (hDevice, &OcrDoc, codeline, confidence, sizeof(codeline));

    printf("barcode %s\n", codeline);

    // image save - FRONT_AUTO  as in MICR reading the FW knows which is the front side
    char fnameImg[] = "OCRB_F.jpg";
    BMSImgSave(hDevice, FRONT_AUTO, NULL, 30, JPEG | ROT_AUTO, fnameImg);
    char *c = strstr(fnameImg, "F.jpg");
    *c = 'R';
    BMSImgSave(hDevice, REAR_AUTO, NULL, 30, JPEG | ROT_AUTO, fnameImg);
    BMSImgFree(hDevice);
}

int main(int argc, char** argv)
{
    
    bool notCalibrated = false;
    BMSResult errcode;
    unsigned long status;
    char dllFname[MAX_PATH] = {0};
    
    char choice;
    
    char ConfigDir[MAX_PATH] = {0};
    
    if (argc < 2){
        printf("using defalt config dir for db, logs and calibration files %s\n", argv[0]);
    } else {
        strcpy(ConfigDir, argv[1]);
        printf("using %s as config dir for db, logs and calibration files\n", ConfigDir);
    }
    
  
    //-----------------------------
    //	K2s initialization. 
    //-----------------------------

    BMSHandle hDevice;
    bool withBadge = false;
    
    char LogFName[MAX_PATH] = {0};
     
    //hDevice = BMSInitializeSN("/media/sf__SW/P_K2s/_BancorMS/__BancorMS_K2S_Linux/K2s", NULL);// init path, generic serial number
    hDevice = BMSInitializeSN(ConfigDir, NULL);// default config dir, set in .ini, generic serial number
    if (hDevice == INVALID_HANDLE_VALUE) {
        errcode = BMSGetLastResult();
        printError();
        return -1;
    }
    
    BMSConfigDirGet (hDevice, ConfigDir);
    printf("ConfigDir %s\n", ConfigDir);
    
    {
        char DBDir[MAX_PATH]={0};
        BMSDBDirGet(hDevice, DBDir, MAX_PATH);
        printf("DBDir %s\n", DBDir);
        BMSDBDirSet(hDevice, DBDir);
   }
   
    
    BMSLogFileName (LogFName);
    printf("LogFName %s\n", LogFName);
    
    // read SN
    {
        char *SerialNumber = NULL;
        short size = 0;

        size = BMSReadSN(hDevice, SerialNumber, size);
        if (size > 0) {
            SerialNumber = (char *) malloc (size); // TO DO - check allocation
            BMSReadSN(hDevice, SerialNumber, size);
            printf("Serial Number %s\n", SerialNumber);
            free(SerialNumber);               
        }
    }


    // read SW and FW information
    {
        char *version = NULL;
        short size = 0;

        size = BMSVersion (hDevice, version, size);
        if (size > 0) {
            version = (char*) malloc(size);
            BMSVersion (hDevice, version, size);
            printf("%s\n", version);
            free(version);
        }
    }
    
    // check K2s options
    {
        unsigned long comp = BMSCompositionL ();
        if (((comp & DEVICE_BADGE1) == DEVICE_BADGE1) || 
            ((comp & DEVICE_BADGE2) == DEVICE_BADGE2) ||
            ((comp & DEVICE_BADGE3) == DEVICE_BADGE3))
            printf("with magnetic strip reader\n");
        if ((comp & DEVICE_MICR) == DEVICE_MICR)
            printf("with MICR\n");
        if ((comp & DEVICE_BACKLIGHTED) == DEVICE_BACKLIGHTED)
            printf("with backlight\n");
    }

    //-----------------------------
    // 2. Check calibration
    //-----------------------------

    errcode = BMSCheckCalibration(hDevice);
    if (BMS_FAILED(errcode)){
        printError();
        goto End;
    }
    if (errcode == BMS_WAR_TOCALIBRATE) {
        notCalibrated = true;
        printf("The Scanner is not Calibrated. \n You need to Calibrate the Scanner first!!!\n");
        printf("To Calibrate the Scanner Select 'c' then Insert (A4) White Page!");
    }

    //---------------------------------------------------
    // 3. Scanner Usage: reading mode, saving, and calibration
    //---------------------------------------------------

    BMSSetParameter( K2S_PAR_TIMEOUT_PHOTOCELL, 10000); // timeout after 10 sec

    int counter ;
    counter =0;

    do {

            int dpi;

            printf("\n[%d]*********************",++counter);
            printf("\nSelect Scanning Mode:\n");
            printf("1) check reading\n");
            printf("2) barcode reading\n");
            printf("c) Calibrate\n");
            printf("f) move Forward\n");
            printf("b) move Backward\n");
            printf("m) magnetic stripe reader\n");
            printf("9) Exit\n");

            printf(" Insert Your Choice: ");
            scanf("%s", &choice);


            switch (choice) {
            case '9':
                    goto End;
            case '1': 
                    ReadCheck(hDevice);
                    break;
            case '2': 
                    ReadBarcode(hDevice);
                    break;
            case 'c':
            case 'C':
            {
                printf("insert a white sheet\n");
                notCalibrated = BMSCalibrate(hDevice)!= BMS__OK;
                if (notCalibrated)
                    printf("calibration error\n");
                dpi = 000;
                break;
            }
            
            case 'f':
            case 'F':
            {
                short forward = 1;
                ushort vRes = 300;
                ushort nLines = vRes * 2; // 2 inches
                BMSSetParameter( K2S_PAR_MAX_HEIGHT_150DPI, 0);
                errcode = BMSMoveScannerLines(hDevice, forward, nLines, vRes);
                //errcode = BMSMoveScanner_mSec ( hDevice, forward, false, 1000);
                if (BMS_FAILED(errcode))
                    printError();
                dpi = 000;
                break;
            }
            case 'b':
            case 'B':
            {
                short forward = 0;
                ushort vRes = 300;
                ushort nLines = vRes * 2; // 2 inches
                errcode = BMSMoveScannerLines(hDevice, forward, nLines, vRes);
                if (BMS_FAILED(errcode))
                    printError();
                dpi = 000;
                break;
            }

            case 'm':
            case 'M':
            {
                unsigned char flags = K2S_MGSTR_NO_START | K2S_MGSTR_NO_STOP | K2S_MGSTR_NO_LCR;
                char Trace1[GENERIC_TRACK_SIZE];
                char Trace2[GENERIC_TRACK_SIZE];
                char Trace3[GENERIC_TRACK_SIZE];
                errcode = BMSMagStripeC(hDevice, Trace1, Trace2, Trace3, flags, GENERIC_TRACK_SIZE);
                if (BMS_FAILED(errcode))
                    printError();
                else {
                    printf("%s\n", Trace1);
                    printf("%s\n", Trace2);
                    printf("%s\n", Trace3);
                }
                // reset not to read the same tracks again
                BMSMagStripeReset(hDevice);

                dpi = 000;
                break;
            }

            case 10: // CR
            case 13: // LF
                dpi = 000;
                break;

            default: 
                    dpi = 000; printf("Invalid choice\n");						break;
            }

    } while (choice != 9);

End:
                   
    errcode = BMSClose(hDevice);
    printf("\nEnd\n");
    return 0;
}

void printError(void)
{
    char *errMsg = NULL;
    int ErrN = BMSGetLastResult();
    short size = BMSErrMsg(ErrN, errMsg, 0);
    if (size > 0) {
        errMsg = (char*) malloc(size); // TO DO - check result
        BMSErrMsg(ErrN, errMsg, size);
    }
    
    printf("return code  %d - %s\n", ErrN, errMsg);
    
}
